<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MontantTypeCaisse extends Model 
{

    protected $table = 'montants_types_caisses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'id_typeCaisse', 'id_entreprise', 'montant', 'statut');
    protected $visible = array('slug', 'id_typeCaisse', 'id_entreprise', 'montant');

    public function entreprise()
    {
        return $this->belongsTo('App\Models\Entreprise', 'id_entreprise');
    }

    public function typeCaisse()
    {
        return $this->belongsTo('App\Models\TypeCaisse', 'id_typeCaisse');
    }

}